// Created by inigo quilez - iq/2013
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

float2 R:TARGETSIZE;
Texture2D tex1 <string uiname="Texture";>;
SamplerState s0 <string uiname="Sampler State";>
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = wrap;
    AddressV = wrap;
};

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;
	float4x4 tW:WORLD;
float time;
float power=1;
float power2=1;
float4 Col1 <bool color=true;> ={0.2,0.1,0.4,1.0};
float4 Col2 <bool color=true;> ={0.3,0.05,0.05,1.0};
float4 Col3 <bool color=true;> ={0.9,0.9,0.9,1.0};
float4 Col4 <bool color=true;> ={0.5,0.2,0.2,1.0};
};

cbuffer cbPerObj:register( b1 )
{

};

float noise( in float2 x )
{
    float2 p = floor(x);
    float2 f = frac(x);
    f = f*f*(3.0-2.0*f);
    
	float a = tex1.SampleLevel(s0,(p+float2(0.5,0.5))/256.0,-32).x;
	float b = tex1.SampleLevel(s0,(p+float2(1.5,0.5))/256.0,-32).x;
	float c = tex1.SampleLevel(s0,(p+float2(0.5,1.5))/256.0,-32).x;
	float d = tex1.SampleLevel(s0,(p+float2(1.5,1.5))/256.0,-32).x;
	
    return lerp(lerp( a, b,f.x), lerp( c, d,f.x),f.y)*power2;
}

float2x2 mtx = float2x2( 0.80,  0.60, -0.60,  0.80 );

float fbm4( float2 p )
{
    float f = 0.0;

    f += 0.5000*(-1.0+2.0*noise( p )); p = mul(mtx,p*2.02);
    f += 0.2500*(-1.0+2.0*noise( p )); p = mul(mtx,p*2.03);
    f += 0.1250*(-1.0+2.0*noise( p )); p = mul(mtx,p*2.01);
    f += 0.0625*(-1.0+2.0*noise( p ));

    return f/0.9375;
}

float fbm6( float2 p )
{
    float f = 0.0;

    f += 0.500000*noise( p ); p = mul(mtx,p*2.02);
    f += 0.250000*noise( p ); p = mul(mtx,p*2.03);
    f += 0.125000*noise( p ); p = mul(mtx,p*2.01);
    f += 0.062500*noise( p ); p = mul(mtx,p*2.04);
    f += 0.031250*noise( p ); p = mul(mtx,p*2.01);
    f += 0.015625*noise( p );

    return f/0.96875;
}

float func( float2 q, out float2 o, out float2 n )
{
    float ql = length( q );
    q.x += 0.05*sin(0.11*time+ql*4.0);
    q.y += 0.05*sin(0.13*time+ql*4.0);
    q *= 0.7 + 0.2*cos(0.05*time);

    q = (q+1.0)*0.5;

    o.x = 0.5 + 0.5*fbm4( float2(2.0*q*float2(1.0,1.0)          )  );
    o.y = 0.5 + 0.5*fbm4( float2(2.0*q*float2(1.0,1.0)+float(5.2))  );

    float ol = length( o );
    o.x += 0.02*sin(0.11*time*ol)/ol;
    o.y += 0.02*sin(0.13*time*ol)/ol;


    n.x = fbm6( float2(4.0*o*float2(1.0,1.0)+float(9.2))  );
    n.y = fbm6( float2(4.0*o*float2(1.0,1.0)+float(5.7))  );

    float2 p = 4.0*q + 4.0*n;

    float f = 0.5 + 0.5*fbm4( p );

    f = lerp( f, f*f*f*3.5, f*abs(n.x) );

    float g = 0.5+0.5*sin(4.0*p.x)*sin(4.0*p.y);
    f *= 1.0-0.5*pow( g, 8.0 );

    return f*power;
}

float funcs( in float2 q )
{
    float2 t1, t2;
    return func(q,t1,t2);
}

struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;

};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW);
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{
    float2 p = In.TexCd.xy;
	float2 q = (-1+In.TexCd.xy) /.25;
	
    float2 o, n;
    float f = func(q, o, n);
    float3 col = float(0.0);


    col = lerp( Col1, Col2, f );
    col = lerp( col,Col3, dot(n,n) );
    col = lerp( col, Col4, 0.5*o.y*o.y );


    col = lerp( col, float3(0.0,0.2,0.4), 0.5*smoothstep(1.2,1.3,abs(n.y)+abs(n.x)) );

    col *= f*2.0;
#if 1
    float2 ex = float2( 1.0 / R.x, 0.0 );
    float2 ey = float2( 0.0, 1.0 / R.y );
	float3 nor = normalize( float3( funcs(q+ex) - f, ex.x, funcs(q+ey) - f ) );
#else
    float3 nor = normalize( float3( ddx(f)*R.x, 1.0, ddy(f)*R.y ) );	
#endif
    float3 lig = normalize( float3( 0.9, -0.2, -0.4 ) );
    float dif = clamp( 0.3+0.7*dot( nor, lig ), 0.0, 1.0 );

    float3 bdrf;
    bdrf  = float3(0.85,0.90,0.95)*(nor.y*0.5+0.5);
    bdrf += float3(0.15,0.10,0.05)*dif;

    bdrf  = float3(0.85,0.90,0.95)*(nor.y*0.5+0.5);
    bdrf += float3(0.15,0.10,0.05)*dif;

    col *= bdrf;

    col = float(1.0)-col;

    col = col*col;

    col *= float3(1.2,1.25,1.2);
	
	col *= 0.5 + 0.5 * sqrt(16.0*p.x*p.y*(1.0-p.x)*(1.0-p.y));
	
	return float4( col, 1.0 );
}


technique10 Warping
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	
	}
}



